﻿var editWorkStation = {
    context: $(".v-editWorkStation"),
    initialize: function () {
        $("#ProntoName", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetProntoServersForAutoComplete", "MultiMode"),
            ajaxParams: { type: 0 },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#ProntoId"),
            select: function (event, data) {
                var prontoId = data.item === undefined ? "0" : data.item.Id;

                $("#RemoteProjectName", editWorkStation.context).a4autocomplete("clearValue");
                $("#RemoteProjectName", editWorkStation.context).a4autocomplete({
                    ajaxParams: { prontoId: prontoId }
                });
            }
        });

        $("#RemoteProjectName", this.context).a4autocomplete({
            ajaxAction: a4.getAction("GetRemoteModulesForAutoComplete", "MultiMode"),
            ajaxParams: { prontoId: $("#ProntoId", editWorkStation.context).val() || "0" },
            valueProperty: "Id",
            labelProperty: "Name",
            altValueField: $("#RemoteProjectId")
        });

        editWorkStation.bindEvents();

        a4.initializeInputs(editWorkStation.context);

        a4.setInputFocus(editWorkStation.context);
    },
    bindEvents: function () {
        
        editWorkStation.context.on("change", "#AllowRemote", function () {
            var allowRemote = $(this).val() == "True";

            $(".v-remoteSettings", editWorkStation.context).toggle(allowRemote);
            $(".v-localSettings", editWorkStation.context).toggle(!allowRemote);
        });
    }
};

$(document).ready(function () {
    if (editWorkStation.context.length > 0) {
        editWorkStation.initialize();
    }
});